/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.pa.problem;

import com.ibm.hwmca.base.pa.ar.XMLHelper;
import com.ibm.hwmca.base.pa.system.RemoteConsoleSystem;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.pa.util.PAPublication;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.msgsvc.Message;
import com.ibm.hwmca.fw.util.msgsvc.MessageId;
import com.ibm.hwmca.fw.util.msgsvc.MessageService;
import com.ibm.hwmca.fw.util.msgsvc.MessageSubscriber;
import com.ibm.hwmca.fw.util.msgsvc.PartitionedMessage;
import com.ibm.hwmca.fw.util.msgsvc.RemoteEntity;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistributedProblemReplicator
implements MessageSubscriber,
PropertyChangeListener {
    private static final String TRACE_MASKT = "XPADPR T";
    private static final String TRACE_MASKF = "XPADPR F";
    private static final String TRACE_MASKD = "XPADPR D";
    private static DistributedProblemReplicator theDPR = null;
    private static ProblemManager thePM = null;
    private Map sequenceMap = new HashMap();
    private static final String DPR_PROBDATA_SYNC_PREFIX = "DPR_PROBDATA_SYNC_";
    private static final String DPR_PROBDATA_SYNC_REQ = "DPR_PROBDATA_SYNC_REQ";
    private static final String DPR_PROBDATA_SYNC_RESP = "DPR_PROBDATA_SYNC_RESP";

    private DistributedProblemReplicator() {
        Trace.trace(TRACE_MASKD, "--> ctor");
        MessageService.getMessageService().subscribeToRemote(this.getMessageId(), (MessageSubscriber)this, false);
        try {
            thePM = ProblemManager.getProblemManager();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initializeSequenceNumbers();
        Trace.trace(TRACE_MASKD, "<-- ctor");
    }

    public static DistributedProblemReplicator getDistributedProblemReplicator() {
        if (theDPR == null) {
            theDPR = new DistributedProblemReplicator();
        }
        return theDPR;
    }

    private MessageId getMessageId() {
        return new MessageId("PA");
    }

    private void initializeSequenceNumbers() {
        List probList = thePM.getAllProblems();
        CommonProblem prob = null;
        DomainIdentifier probDomId = null;
        PASystem analyzingSys = null;
        for (int i = 0; i < probList.size(); ++i) {
            if (!(probList.get(i) instanceof CommonProblem) || !(prob = (CommonProblem)probList.get(i)).isReplicatable() || (probDomId = prob.getDomainId()) == null || (analyzingSys = prob.getPrimaryAnalyzingConsoleSystem()) == null) continue;
            this.setSequenceNumber(probDomId, analyzingSys, prob.getSequenceNumber());
        }
    }

    private synchronized void setSequenceNumber(DomainIdentifier domId, PASystem sys, int seqNumber) {
        Integer currSeqNumber;
        HashMap<PASystem, Integer> domainMap = (HashMap<PASystem, Integer>)this.sequenceMap.get(domId);
        if (domainMap == null) {
            domainMap = new HashMap<PASystem, Integer>();
            this.sequenceMap.put(domId, domainMap);
        }
        if ((currSeqNumber = (Integer)domainMap.get(sys)) == null) {
            domainMap.put(sys, new Integer(seqNumber));
        } else if (currSeqNumber <= seqNumber) {
            domainMap.put(sys, new Integer(seqNumber));
        }
    }

    private synchronized void setSequenceNumber(CommonProblem prob) {
        DomainIdentifier domid = prob.getDomainId();
        PASystem analyzingSys = prob.getPrimaryAnalyzingConsoleSystem();
        if (domid == null || analyzingSys == null) {
            Trace.trace(TRACE_MASKT, "can't update sequence number - missing domain id or analyzing sys");
        } else {
            this.setSequenceNumber(domid, analyzingSys, prob.getSequenceNumber());
        }
    }

    private synchronized int getSequenceNumber(DomainIdentifier domId, PASystem sys) {
        Map domainMap = (Map)this.sequenceMap.get(domId);
        if (domainMap == null) {
            return Integer.MIN_VALUE;
        }
        Integer currSeqNumber = (Integer)domainMap.get(sys);
        if (currSeqNumber == null) {
            return Integer.MIN_VALUE;
        }
        return currSeqNumber;
    }

    private synchronized Map getSequenceNumbers(DomainIdentifier domId) {
        return (Map)this.sequenceMap.get(domId);
    }

    public void synchronizeProblems(DomainIdentifier domId, Set targetSystems) {
        Iterator targetIter = targetSystems.iterator();
        while (targetIter.hasNext()) {
            this.sendSyncRequest((RemoteConsoleSystem)targetIter.next(), domId, null, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent evt) {
        String evtName = evt.getPropertyName();
        if (!evtName.startsWith("Problem")) {
            return;
        }
        Trace.trace(TRACE_MASKD, "--> propertyChange evtName=" + evtName);
        Problem prob = null;
        prob = evtName.equals("ProblemInventoryProperty") ? (Problem)evt.getNewValue() : (Problem)evt.getOldValue();
        if (prob == null || !(prob instanceof CommonProblem)) {
            Trace.trace(TRACE_MASKD, "<-- propertyChange: Null or non-CommonProblem");
            return;
        }
        CommonProblem cp = (CommonProblem)prob;
        if (!cp.isReplicatable()) {
            Trace.trace(TRACE_MASKD, "<-- propertyChange: Not replicatable");
            return;
        }
        Domain probDom = cp.getDomain();
        if (probDom == null || !(probDom instanceof DistributedAnalysisDomain) || !((DistributedAnalysisDomain)probDom).isPrimary()) {
            Trace.trace(TRACE_MASKD, "<-- propertyChange: No domain, not distributed, or not primary");
            return;
        }
        PASystem analyzingSys = cp.getPrimaryAnalyzingConsoleSystem();
        if (analyzingSys == null) {
            Trace.trace(TRACE_MASKD, "<-- propertyChange: No analyzing console system set");
            return;
        }
        Trace.trace(TRACE_MASKD, "prob num=" + prob.getProblemNumber());
        Trace.trace(TRACE_MASKD, "domain=" + probDom.getDomainId().getDID());
        Trace.trace(TRACE_MASKD, "primaryAnalyzing=" + analyzingSys.getSystemName());
        DistributedProblemReplicator distributedProblemReplicator = this;
        synchronized (distributedProblemReplicator) {
            int seqNumber = this.getSequenceNumber(probDom.getDomainId(), analyzingSys);
            seqNumber = seqNumber == Integer.MIN_VALUE ? 1 : ++seqNumber;
            Trace.trace(TRACE_MASKD, "assigning seq num=" + seqNumber);
            cp.setSequenceNumber(seqNumber);
            try {
                thePM.secondaryChanged(cp);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKD, "<-- propertyChange: Problem assigning sequence number");
                Trace.trace(TRACE_MASKD, e);
                return;
            }
            this.setSequenceNumber(probDom.getDomainId(), analyzingSys, seqNumber);
        }
        Trace.trace(TRACE_MASKF, "Replicating problem event");
        try {
            ((DistributedAnalysisDomain)probDom).broadcastMessage(new PartitionedMessage(this.getMessageId(), (Serializable)((Object)evtName), (Serializable)((Object)this.marshalProblem(cp))));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "could not replicate problem");
            Trace.trace(TRACE_MASKT, e);
        }
        Trace.trace(TRACE_MASKD, "<-- propertyChange");
    }

    public void receiveMessage(Message msg, Object sender2) {
        if (!msg.getMessageId().getId().equals(this.getMessageId().getId()) || !(msg instanceof PartitionedMessage)) {
            return;
        }
        String partition = (String)((Object)((PartitionedMessage)msg).getPartition());
        if (!partition.startsWith("Problem") && !partition.startsWith(DPR_PROBDATA_SYNC_PREFIX)) {
            return;
        }
        RemoteConsoleSystem rcs = new RemoteConsoleSystem((RemoteEntity)sender2);
        Trace.trace(TRACE_MASKD, "--> receiveMessage");
        Trace.trace(TRACE_MASKD, "sender: " + rcs);
        Trace.trace(TRACE_MASKD, "msg partition: " + partition);
        if (partition.startsWith("Problem")) {
            this.handlePropertyEvent(msg, rcs);
        } else if (partition.equals(DPR_PROBDATA_SYNC_REQ)) {
            this.handleSyncRequest((SyncRequestBlock)msg.getPayload(), rcs);
        } else if (partition.equals(DPR_PROBDATA_SYNC_RESP)) {
            this.handleSyncResponse((SyncResponseBlock)msg.getPayload(), rcs);
        }
        Trace.trace(TRACE_MASKD, "<-- receiveMessage");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlePropertyEvent(Message msg, RemoteConsoleSystem sender2) {
        String partition = (String)((Object)((PartitionedMessage)msg).getPartition());
        CommonProblem remoteProblem = null;
        try {
            remoteProblem = this.unmarshalProblem((String)((Object)msg.getPayload()));
            remoteProblem.localize();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "<-> handlePropertyEvent: Could not rebuild problem");
            Trace.trace(TRACE_MASKT, e);
            return;
        }
        Domain probDom = remoteProblem.getDomain();
        if (probDom == null || !(probDom instanceof DistributedAnalysisDomain)) {
            Trace.trace(TRACE_MASKT, "<-> handlePropertyEvent: Error processing problem domain");
            return;
        }
        PASystem analyzingSys = remoteProblem.getPrimaryAnalyzingConsoleSystem();
        int localSeqNumber = this.getSequenceNumber(probDom.getDomainId(), analyzingSys);
        int remoteSeqNumber = remoteProblem.getSequenceNumber();
        if (((DistributedAnalysisDomain)probDom).isPrimary()) {
            if (partition.equals("ProblemOpenProperty")) {
                Problem localProblem = thePM.getProblem(remoteProblem.getUniqueKey());
                if (localProblem != null) return;
                try {
                    thePM.add(remoteProblem);
                    return;
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "Exception adding problem: " + remoteProblem.getUniqueKey());
                    Trace.trace(TRACE_MASKT, e);
                }
                return;
            }
            Trace.trace(TRACE_MASKD, "<-> handlePropertyEvent: extraneous message discarded");
            return;
        }
        if (remoteSeqNumber <= localSeqNumber) {
            Trace.trace(TRACE_MASKD, "<-> handlePropertyEvent: ignoring problem with old/redundant sequence number (current seq num=" + localSeqNumber + ")");
            return;
        }
        if (remoteSeqNumber == localSeqNumber + 1 || remoteSeqNumber == 1 && localSeqNumber == Integer.MIN_VALUE) {
            Trace.trace(TRACE_MASKD, "<-> handlePropertyEvent: Processing problem event");
            if (partition.equals("ProblemInventoryProperty")) {
                try {
                    thePM.add(remoteProblem);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-> handlePropertyEvent: Exception adding problem: " + remoteProblem.getUniqueKey());
                    Trace.trace(TRACE_MASKT, e);
                    return;
                }
            }
            if (partition.equals("ProblemOpenProperty")) {
                try {
                    thePM.add(remoteProblem);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-> handlePropertyEvent: Exception adding problem: " + remoteProblem.getUniqueKey());
                    Trace.trace(TRACE_MASKT, e);
                    return;
                }
            }
            if (partition.equals("ProblemCloseProperty")) {
                try {
                    thePM.secondaryClose(remoteProblem);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-> handlePropertyEvent: Exception closing problem: " + remoteProblem.getUniqueKey());
                    Trace.trace(TRACE_MASKT, e);
                    return;
                }
            }
            if (partition.equals("ProblemChangedProperty")) {
                try {
                    thePM.secondaryChanged(remoteProblem);
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKT, "<-> handlePropertyEvent: Exception changing problem: " + remoteProblem.getUniqueKey());
                    Trace.trace(TRACE_MASKT, e);
                    return;
                }
            }
            this.setSequenceNumber(probDom.getDomainId(), analyzingSys, remoteSeqNumber);
            return;
        }
        Trace.trace(TRACE_MASKD, "<-> handlePropertyEvent: Sending resync request (our seq num=" + localSeqNumber + ")");
        this.sendSyncRequest(sender2, probDom.getDomainId(), analyzingSys, localSeqNumber);
    }

    private String marshalProblem(CommonProblem problem) {
        StringBuffer probBuffer = new StringBuffer();
        XMLHelper.outToXML(problem, probBuffer, problem.getClass());
        return probBuffer.toString();
    }

    private CommonProblem unmarshalProblem(String xmlProblem) throws HException {
        String probTag = xmlProblem.substring(1, xmlProblem.indexOf(" "));
        CommonProblem prob = (CommonProblem)XMLHelper.rebuildObject(xmlProblem, probTag);
        Trace.trace(TRACE_MASKF, "problem number:" + prob.getProblemNumber());
        Trace.trace(TRACE_MASKF, "problem domain:" + prob.getDomainId().getDID());
        Trace.trace(TRACE_MASKF, "sequence number:" + prob.getSequenceNumber());
        Trace.trace(TRACE_MASKF, "reporting RemoteMachineSystem:" + prob.getReportingRemoteMachineSystem());
        Trace.trace(TRACE_MASKF, "primary analyzing ConsoleSystem:" + prob.getPrimaryAnalyzingConsoleSystem());
        Trace.trace(TRACE_MASKF, "failing system:" + prob.getFailingSystem());
        return prob;
    }

    private void sendSyncRequest(RemoteConsoleSystem target, DomainIdentifier domId, PASystem analyzingSys, int lastSequenceNumber) {
        SyncRequestBlock request = new SyncRequestBlock();
        request.domainId = domId;
        if (analyzingSys != null) {
            request.pacs = new PASystem[1];
            request.pacs[0] = analyzingSys;
            request.lastSeqNumber = new int[1];
            request.lastSeqNumber[0] = lastSequenceNumber;
        } else {
            Map seqNumberMap = this.getSequenceNumbers(domId);
            if (seqNumberMap != null) {
                Set sysSet = seqNumberMap.keySet();
                request.pacs = new PASystem[sysSet.size()];
                request.lastSeqNumber = new int[sysSet.size()];
                Iterator sysIter = sysSet.iterator();
                int i = 0;
                while (sysIter.hasNext()) {
                    request.pacs[i] = (PASystem)sysIter.next();
                    request.lastSeqNumber[i] = (Integer)seqNumberMap.get(request.pacs[i]);
                    ++i;
                }
            }
        }
        try {
            Trace.trace(TRACE_MASKD, "<-> sendSyncRequest: publishing problem data synchronization request for " + request.domainId.getDID() + " to " + target);
            PAPublication.queuePublication(target, (Message)new PartitionedMessage(this.getMessageId(), (Serializable)((Object)DPR_PROBDATA_SYNC_REQ), request));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, e);
        }
    }

    private void handleSyncRequest(SyncRequestBlock request, RemoteConsoleSystem sender2) {
        Trace.trace(TRACE_MASKD, "--> handleSyncRequest (for " + request.domainId.getDID() + ")");
        HashSet<Problem> updatedProblems = new HashSet<Problem>();
        Iterator probIter = thePM.getAllProblems().iterator();
        Problem prob = null;
        PASystem probSys = null;
        boolean foundSys = false;
        while (probIter.hasNext()) {
            prob = (Problem)probIter.next();
            if (!prob.isReplicatable() || prob.getSequenceNumber() == Integer.MIN_VALUE || !(prob instanceof CommonProblem) || !((CommonProblem)prob).getDomainId().equals(request.domainId)) continue;
            probSys = ((CommonProblem)prob).getPrimaryAnalyzingConsoleSystem();
            foundSys = false;
            if (request.pacs != null) {
                for (int i = 0; i < request.pacs.length && !foundSys; ++i) {
                    if (!probSys.equals(request.pacs[i])) continue;
                    foundSys = true;
                    if (prob.getSequenceNumber() <= request.lastSeqNumber[i]) continue;
                    updatedProblems.add(prob);
                }
            }
            if (foundSys) continue;
            updatedProblems.add(prob);
        }
        if (updatedProblems.size() == 0) {
            Trace.trace(TRACE_MASKD, "<-- handleSyncRequest: no problem data to send");
            return;
        }
        SyncResponseBlock response = new SyncResponseBlock();
        response.problems = new String[updatedProblems.size()];
        StringBuffer probBuffer = new StringBuffer();
        probIter = updatedProblems.iterator();
        int i = 0;
        while (probIter.hasNext()) {
            response.problems[i++] = this.marshalProblem((CommonProblem)probIter.next());
        }
        try {
            Trace.trace(TRACE_MASKD, "<-- handleSyncRequest: publishing problem data response for " + request.domainId.getDID() + " to " + sender2 + " (" + response.problems.length + " problems)");
            PAPublication.queuePublication(sender2, (Message)new PartitionedMessage(this.getMessageId(), (Serializable)((Object)DPR_PROBDATA_SYNC_RESP), response));
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, e);
        }
    }

    private void handleSyncResponse(SyncResponseBlock response, RemoteConsoleSystem sender2) {
        Trace.trace(TRACE_MASKD, "--> handleSyncResponse (" + response.problems.length + " problems)");
        String[] problems = response.problems;
        CommonProblem remoteProblem = null;
        for (int i = 0; i < problems.length; ++i) {
            try {
                remoteProblem = this.unmarshalProblem(problems[i]);
                remoteProblem.localize();
                Problem localProblem = thePM.getProblem(remoteProblem.getUniqueKey());
                if (localProblem == null) {
                    Trace.trace(TRACE_MASKD, "adding unknown problem (unique key=" + remoteProblem.getUniqueKey() + ")");
                    thePM.add(remoteProblem);
                    this.setSequenceNumber(remoteProblem);
                    continue;
                }
                if (remoteProblem.getSequenceNumber() > localProblem.getSequenceNumber()) {
                    Trace.trace(TRACE_MASKD, "changing problem");
                    thePM.secondaryChanged(remoteProblem);
                    this.setSequenceNumber(remoteProblem);
                    continue;
                }
                Trace.trace(TRACE_MASKD, "ignoring old/redundant problem change (current seq num=" + localProblem.getSequenceNumber() + ")");
                continue;
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "<-- handleSyncResponse: Could not process incoming problem data");
                Trace.trace(TRACE_MASKT, e);
            }
        }
        Trace.trace(TRACE_MASKD, "<-- handleSyncResponse");
    }

    private static class SyncResponseBlock
    implements Serializable {
        protected String[] problems = null;

        private SyncResponseBlock() {
        }
    }

    private static class SyncRequestBlock
    implements Serializable {
        protected DomainIdentifier domainId = null;
        protected PASystem[] pacs = null;
        protected int[] lastSeqNumber = null;

        private SyncRequestBlock() {
        }
    }
}

